/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.content;

import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMSession;
import filenet.sim.api.VWSIMSimulationVerifyException;
import filenet.sim.toolkit.console.IVWSIMConsoleActionListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleActionEvent;
import filenet.sim.toolkit.console.VWSIMConsolePerformer;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.VWSIMScenarioNode;
import filenet.sim.toolkit.console.VWSIMSimulationLaunchResult;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.content.VWSIMListViewPane;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class VWSIMConsoleContentViewPane
extends JPanel
implements ActionListener,
IVWSIMConsoleActionListener {
    protected static Logger logger = Logger.getLogger("filenet.sim.toolkit.console");
    private static final String m_className = "VWSIMConsoleContentViewPane";
    protected VWSIMBaseNode m_focus;
    protected VWSIMBaseNode m_currentFolder;
    protected VWSIMConsolePerformer m_performer = null;
    private VWSIMListViewPane m_listViewPane = null;
    private int m_viewMode = 0;
    private CardLayout m_cardLayout = null;
    private EventListenerList m_listenerList = null;
    private Container m_parentContainer = null;
    private VWSIMSession m_simSession = null;
    private VWSession m_vwSession = null;
    protected Frame m_parentFrame = null;
    private RefreshThread m_refreshThread = null;
    private Date m_lastRefreshTime = new Date();
    private long m_refreshInterval = 30000L;
    private boolean m_bStopThread = false;

    public VWSIMConsoleContentViewPane() {
        this.m_listenerList = new EventListenerList();
    }

    public void init(VWSIMBaseNode node, int viewMode, Container parentContainer, Frame parentFrame, VWSIMConsolePerformer consolePeformer, VWSession theVWSession, VWSIMSession theSIMSession) {
        this.m_parentContainer = parentContainer;
        this.m_parentFrame = parentFrame;
        this.m_performer = consolePeformer;
        this.m_vwSession = theVWSession;
        this.m_simSession = theSIMSession;
        this.m_listViewPane = new VWSIMListViewPane(this);
        this.m_cardLayout = new CardLayout();
        this.setLayout(this.m_cardLayout);
        this.add((Component)this.m_listViewPane, VWSIMResource.ListView);
        this.fetchRefreshInterval();
        this.m_refreshThread = new RefreshThread("SIM Console auto refresh Thread");
        this.m_refreshThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeFocus(VWSIMBaseNode node) {
        try {
            this.m_parentFrame.setCursor(new Cursor(3));
            this.setFocus(node);
            this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 16));
            this.m_parentFrame.setCursor(new Cursor(0));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parentFrame.setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFocus(VWSIMBaseNode node) {
        VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
        synchronized (vWSIMListViewPane) {
            this.m_focus = node;
            if (this.m_focus instanceof VWSIMFolderNode) {
                this.m_currentFolder = this.m_focus;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRefreshInterval(long refreshInterval) {
        if (refreshInterval >= 30000L) {
            VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
            synchronized (vWSIMListViewPane) {
                this.m_refreshInterval = refreshInterval;
            }
        }
    }

    protected long getRefreshInterval() {
        return this.m_refreshInterval;
    }

    public void setViewMode(int viewMode) {
        this.m_viewMode = viewMode;
        this.refreshContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedRow() {
        VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
        synchronized (vWSIMListViewPane) {
            VWSIMFolderNode parentFolder = null;
            switch (this.m_focus.getType()) {
                case 33: {
                    parentFolder = (VWSIMFolderNode)((VWSIMScenarioNode)this.m_focus).getParent();
                    break;
                }
                case 34: {
                    parentFolder = (VWSIMFolderNode)((VWSIMSimulationNode)this.m_focus).getParent();
                }
            }
            this.m_listViewPane.deleteSelectedRow();
            this.changeFocus(parentFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(Object obj) {
        VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
        synchronized (vWSIMListViewPane) {
            this.m_listViewPane.addRow(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshContent(VWSIMBaseNode folderNode) {
        try {
            this.m_parentFrame.setCursor(new Cursor(3));
            VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
            synchronized (vWSIMListViewPane) {
                int nodeType = folderNode.getType();
                switch (nodeType) {
                    case 16: 
                    case 17: 
                    case 18: {
                        this.m_listViewPane.displayContent(folderNode);
                        this.m_listViewPane.updateUI();
                        this.m_lastRefreshTime = new Date();
                        break;
                    }
                    case 33: {
                        VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)folderNode;
                        aScnNode.refresh();
                        this.m_listViewPane.updateUI();
                        break;
                    }
                    case 34: {
                        VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)folderNode;
                        aSimNode.refresh();
                        this.m_listViewPane.updateUI();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parentFrame.setCursor(new Cursor(0));
        }
    }

    public void refreshContent() {
        this.refreshContent(this.m_focus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        int nodeType = this.m_focus.getType();
        try {
            this.m_parentFrame.setCursor(new Cursor(3));
            VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
            synchronized (vWSIMListViewPane) {
                block40: {
                    if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_OPEN_SCENARIO) == 0) {
                        this.m_performer.launchScenarioDesigner(this.m_focus);
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_VIEW_SCENARIO) == 0) {
                        this.m_performer.launchScenarioDesigner(this.m_focus);
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_VIEW_ANIMATION) == 0) {
                        try {
                            this.m_performer.viewAnimation(this.m_focus);
                        }
                        catch (VWSIMSimulationVerifyException verifyEx) {
                            if (this.m_focus.getType() == 34) {
                                VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)this.m_focus;
                                String msg = VWSIMResource.FailedVerifySimulationDoDelete.toString(aSimNode.getName());
                                int ret = JOptionPane.showConfirmDialog(this.m_parentFrame, msg, VWSIMResource.Error, 1);
                                if (ret == 0) {
                                    IVWIDMDocument aIVWIDMDocument = (IVWIDMDocument)aSimNode.getIdmItem();
                                    aIVWIDMDocument.delete();
                                    this.deleteSelectedRow();
                                }
                                break block40;
                            }
                            VWDebug.logException(verifyEx);
                        }
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_RUN_SIMULATION) == 0) {
                        VWSIMSimulationLaunchResult result = this.m_performer.launchSimulation(this.m_focus);
                        if (result != null) {
                            try {
                                IVWIDMFolder[] folderList = result.getFolderFiledIn();
                                if (folderList != null && folderList.length > 0) {
                                    VWSIMFolderNode focusedFolder = (VWSIMFolderNode)this.m_focus.getParent();
                                    String folderId = focusedFolder.getIdmItem().getId();
                                    boolean bInCurrentFolder = false;
                                    for (int i = 0; i < folderList.length; ++i) {
                                        String filedInFolderId = folderList[i].getId();
                                        if (folderId.compareTo(filedInFolderId) != 0) continue;
                                        bInCurrentFolder = true;
                                        break;
                                    }
                                    if (bInCurrentFolder) {
                                        IVWSIMSimulation aIVWSIMSimulation = result.getSimulation();
                                        IVWIDMDocument aIVWIDMItem = aIVWSIMSimulation.getIDMDocument();
                                        VWSIMSimulationNode aSimNode = new VWSIMSimulationNode((IVWIDMItem)aIVWIDMItem, aIVWSIMSimulation, focusedFolder);
                                        aSimNode.setSIMSession(this.m_simSession);
                                        aSimNode.setVWSession(this.m_vwSession);
                                        this.addRow(aSimNode);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                        }
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_STOP_SIMULATION) == 0) {
                        this.m_performer.stopSimulation(this.m_focus);
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_REFRESH) == 0) {
                        switch (nodeType) {
                            case 33: {
                                VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)this.m_focus;
                                aScnNode.refresh();
                                break;
                            }
                            case 34: {
                                VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)this.m_focus;
                                aSimNode.refresh();
                            }
                        }
                        this.updateUI();
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_PROPERTIES) == 0) {
                        this.m_performer.performProperties(this.m_focus);
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_DELETE) == 0) {
                        if (this.m_performer.performDelete(this.m_focus)) {
                            this.deleteSelectedRow();
                        }
                    } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_HELP) == 0) {
                        this.m_performer.performHelp(this.m_focus);
                    }
                }
            }
            this.m_parentFrame.setCursor(new Cursor(0));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parentFrame.setCursor(new Cursor(0));
            this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 512));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consoleActionPerformed(VWSIMConsoleActionEvent evt) {
        VWSIMBaseNode baseNode = evt.getBaseNode();
        int conSoleAction = evt.getAction();
        VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
        synchronized (vWSIMListViewPane) {
            try {
                if (evt.setFocus()) {
                    this.clearSelection();
                    this.setFocus(baseNode);
                }
                if (evt.refresh()) {
                    this.refreshContent();
                }
                if (evt.delete()) {
                    this.deleteSelectedRow();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                VWDebug.logException(ex);
            }
        }
    }

    public void addConsoleActionListener(IVWSIMConsoleActionListener cal) {
        this.m_listenerList.add(IVWSIMConsoleActionListener.class, cal);
    }

    private void fireConsoleActionEvent(VWSIMConsoleActionEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWSIMConsoleActionListener.class) continue;
            ((IVWSIMConsoleActionListener)listeners[i + 1]).consoleActionPerformed(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSelection() {
        VWSIMListViewPane vWSIMListViewPane = this.m_listViewPane;
        synchronized (vWSIMListViewPane) {
            this.m_listViewPane.clearSelection();
        }
    }

    private void fetchRefreshInterval() {
        try {
            Double oInterval;
            VWUserInfo userInfo = this.m_vwSession.fetchCurrentUserInfo();
            if (userInfo != null && (oInterval = (Double)userInfo.getFieldValue("sim_console_refresh_interval")) != null && oInterval.longValue() >= 30000L) {
                this.m_refreshInterval = oInterval.longValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void releaseResources() {
        this.m_focus = null;
        this.m_performer = null;
        this.m_refreshThread.stopThread();
        this.m_refreshThread = null;
        if (this.m_listViewPane != null) {
            this.m_listViewPane.releaseResources();
            this.m_listViewPane = null;
        }
        this.m_cardLayout = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWSIMConsoleActionListener.class, (IVWSIMConsoleActionListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        this.m_parentContainer = null;
        this.m_parentFrame = null;
        this.removeAll();
    }

    class RefreshThread
    extends Thread {
        private volatile Thread m_thisThread;

        public RefreshThread(String theName) {
            super(theName);
        }

        public void stopThread() {
            this.m_thisThread = null;
            VWSIMConsoleContentViewPane.this.m_bStopThread = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String m_method = "RefreshThread";
            try {
                this.m_thisThread = Thread.currentThread();
                while (VWSIMConsoleContentViewPane.this.m_refreshThread == this.m_thisThread && !VWSIMConsoleContentViewPane.this.m_bStopThread) {
                    Date dt = new Date();
                    VWSIMListViewPane vWSIMListViewPane = VWSIMConsoleContentViewPane.this.m_listViewPane;
                    synchronized (vWSIMListViewPane) {
                        if (VWSIMConsoleContentViewPane.this.m_currentFolder != null) {
                            int nodeType = VWSIMConsoleContentViewPane.this.m_currentFolder.getType();
                            if (nodeType != 17) {
                                String itemId = VWSIMConsoleContentViewPane.this.m_listViewPane.getSelectedItemId();
                                if (VWSIMConsoleContentViewPane.this.m_parentFrame != null) {
                                    VWSIMConsoleContentViewPane.this.m_parentFrame.setCursor(new Cursor(3));
                                }
                                VWSIMConsoleContentViewPane.this.m_listViewPane.displayContent(VWSIMConsoleContentViewPane.this.m_currentFolder);
                                int selIdx = VWSIMConsoleContentViewPane.this.m_listViewPane.findItem(itemId);
                                if (selIdx >= 0) {
                                    VWSIMConsoleContentViewPane.this.m_listViewPane.clearSelection();
                                    VWSIMConsoleContentViewPane.this.m_focus = VWSIMConsoleContentViewPane.this.m_listViewPane.setSelectedRow(selIdx);
                                    VWSIMConsoleContentViewPane.this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, VWSIMConsoleContentViewPane.this.m_focus, 16));
                                } else {
                                    VWSIMConsoleContentViewPane.this.m_listViewPane.clearSelection();
                                    VWSIMConsoleContentViewPane.this.changeFocus(VWSIMConsoleContentViewPane.this.m_currentFolder);
                                }
                                if (VWSIMConsoleContentViewPane.this.m_parentFrame != null) {
                                    VWSIMConsoleContentViewPane.this.m_parentFrame.setCursor(new Cursor(0));
                                }
                                if (logger.isFinest()) {
                                    logger.finest(VWSIMConsoleContentViewPane.m_className, "RefreshThread", "Wakeup at " + dt.toString() + ", auto refreshing, last refresh " + VWSIMConsoleContentViewPane.this.m_lastRefreshTime + ", sleep " + VWSIMConsoleContentViewPane.this.m_refreshInterval + "/" + VWSIMConsoleContentViewPane.this.m_refreshInterval);
                                }
                                VWSIMConsoleContentViewPane.this.m_lastRefreshTime = dt;
                            } else if (logger.isFinest()) {
                                logger.finest(VWSIMConsoleContentViewPane.m_className, "RefreshThread", "Wakeup at " + dt.toString() + ", skip auto refresh " + dt.toString() + ", last refresh " + VWSIMConsoleContentViewPane.this.m_lastRefreshTime + ", sleep " + VWSIMConsoleContentViewPane.this.m_refreshInterval);
                            }
                        }
                    }
                    Thread.sleep(VWSIMConsoleContentViewPane.this.m_refreshInterval);
                }
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (VWSIMConsoleContentViewPane.this.m_parentFrame != null) {
                    VWSIMConsoleContentViewPane.this.m_parentFrame.setCursor(new Cursor(0));
                }
            }
        }
    }
}

